import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:just_the_tooltip/just_the_tooltip.dart';
import 'package:sixam_mart_store/common/widgets/custom_bottom_sheet_widget.dart';
import 'package:sixam_mart_store/features/store/controllers/store_controller.dart';
import 'package:sixam_mart_store/features/rental_module/provider/widgets/announcement_status_bottom_sheet.dart';
import 'package:sixam_mart_store/util/dimensions.dart';
import 'package:sixam_mart_store/util/styles.dart';
import 'package:sixam_mart_store/common/widgets/custom_app_bar_widget.dart';
import 'package:sixam_mart_store/common/widgets/custom_button_widget.dart';
import 'package:sixam_mart_store/common/widgets/custom_snackbar_widget.dart';
import 'package:sixam_mart_store/common/widgets/custom_text_field_widget.dart';

class TaxiAnnouncementScreen extends StatefulWidget {
  final int announcementStatus;
  final String announcementMessage;
  const TaxiAnnouncementScreen({super.key, required this.announcementStatus, required this.announcementMessage});

  @override
  State<TaxiAnnouncementScreen> createState() => _TaxiAnnouncementScreenState();
}
class _TaxiAnnouncementScreenState extends State<TaxiAnnouncementScreen> {

  final tooltipController = JustTheController();
  final TextEditingController _announcementController = TextEditingController();

  @override
  void initState() {
    Get.find<StoreController>().setAnnouncementStatus(widget.announcementStatus == 1 ? true : false, willUpdate: false);
    _announcementController.text = widget.announcementMessage;
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<StoreController>(builder: (storeController) {
        return Scaffold(
          appBar: CustomAppBarWidget(
            title: 'announcement'.tr,
            menuWidget: Transform.scale(
              scale: 0.7,
              child: CupertinoSwitch(
                inactiveTrackColor: Theme.of(context).primaryColor.withValues(alpha: 0.5),
                activeTrackColor: Theme.of(context).primaryColor,
                value: storeController.announcementStatus,
                onChanged: (value) {
                  showCustomBottomSheet(child: const AnnouncementStatusBottomSheet());
                },
              ),
            ),
          ),

          body: Padding(
            padding: const EdgeInsets.all(Dimensions.paddingSizeDefault),
            child: Column(children: [

              Row(children: [
                Text("announcement_content".tr, style: robotoRegular),
                const SizedBox(width: Dimensions.paddingSizeExtraSmall),

                JustTheTooltip(
                  backgroundColor: Get.isDarkMode ? Colors.white : Colors.black87,
                  controller: tooltipController,
                  preferredDirection: AxisDirection.down,
                  tailLength: 14,
                  tailBaseWidth: 20,
                  content: Padding(
                    padding: const EdgeInsets.all(8.0),
                    child: Text('this_feature_is_for_sharing_important_information_or_announcements_related_to_the_vendor'.tr,style: robotoRegular.copyWith(color: Theme.of(context).cardColor)),
                  ),
                  child: InkWell(
                    onTap: () => tooltipController.showTooltip(),
                    child: const Icon(Icons.info_outline, size: 15),
                  ),
                  // child: const Icon(Icons.info_outline),
                ),
              ]),
              const SizedBox(height: Dimensions.paddingSizeDefault),

              CustomTextFieldWidget(
                hintText: "type_announcement".tr,
                showLabelText: false,
                controller: _announcementController,
                maxLines: 5,
                inputAction: TextInputAction.done,
              ),
              const SizedBox(height: Dimensions.paddingSizeDefault),

              CustomButtonWidget(
                isLoading: storeController.isLoading,
                onPressed: () {
                  if(_announcementController.text.isEmpty) {
                    showCustomSnackBar('enter_announcement'.tr);
                  }else {
                    storeController.updateAnnouncement(storeController.announcementStatus ? 1 : 0, _announcementController.text);
                  }
                },
                buttonText: 'publish'.tr,
              ),

            ]),
          ),
        );
      }
    );
  }
}
